/*
 * Decompiled with CFR 0.152.
 */
package frink.graphics;

import frink.graphics.Point3DDouble;
import frink.graphics.Point3DInt;

public class Point3DFloat {
    public float x;
    public float y;
    public float z;

    public Point3DFloat(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
    }

    public Point3DFloat(Point3DInt point3DInt) {
        this.x = point3DInt.x;
        this.y = point3DInt.y;
        this.z = point3DInt.z;
    }

    public static Point3DFloat makeNormal(float f2, float f3, float f4) {
        double d2 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        if (d2 == 0.0) {
            return new Point3DFloat(f2, f3, f4);
        }
        double d3 = 1.0 / d2;
        return new Point3DFloat((float)((double)f2 * d3), (float)((double)f3 * d3), (float)((double)f4 * d3));
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static float length(float f2, float f3, float f4) {
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static float lengthSquared(float f2, float f3, float f4) {
        return f2 * f2 + f3 * f3 + f4 * f4;
    }

    public Point3DFloat normalize() {
        return Point3DFloat.makeNormal(this.x, this.y, this.z);
    }

    public void normalizeInPlace() {
        double d2 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (d2 == 0.0) {
            return;
        }
        double d3 = 1.0 / d2;
        this.x = (float)((double)this.x * d3);
        this.y = (float)((double)this.y * d3);
        this.z = (float)((double)this.z * d3);
    }

    public Point3DFloat subtract(Point3DFloat point3DFloat) {
        return Point3DFloat.subtract(this, point3DFloat);
    }

    public static Point3DFloat subtract(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        return new Point3DFloat(point3DFloat.x - point3DFloat2.x, point3DFloat.y - point3DFloat2.y, point3DFloat.z - point3DFloat2.z);
    }

    public void subtractInPlace(Point3DFloat point3DFloat) {
        this.x -= point3DFloat.x;
        this.y -= point3DFloat.y;
        this.z -= point3DFloat.z;
    }

    public void subtractInPlace(float f2, float f3, float f4) {
        this.x -= f2;
        this.y -= f3;
        this.z -= f4;
    }

    public Point3DFloat add(Point3DFloat point3DFloat) {
        return Point3DFloat.add(this, point3DFloat);
    }

    public static Point3DFloat add(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        return new Point3DFloat(point3DFloat.x + point3DFloat2.x, point3DFloat.y + point3DFloat2.y, point3DFloat.z + point3DFloat2.z);
    }

    public void addInPlace(Point3DFloat point3DFloat) {
        this.x += point3DFloat.x;
        this.y += point3DFloat.y;
        this.z += point3DFloat.z;
    }

    public void addInPlace(float f2, float f3, float f4) {
        this.x += f2;
        this.y += f3;
        this.z += f4;
    }

    public float addLength(Point3DFloat point3DFloat) {
        float f2 = this.x + point3DFloat.x;
        float f3 = this.y + point3DFloat.y;
        float f4 = this.z + point3DFloat.z;
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public Point3DFloat multiply(float f2) {
        return new Point3DFloat(this.x * f2, this.y * f2, this.z * f2);
    }

    public void multiplyInPlace(float f2) {
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
    }

    public float multiplyLength(float f2) {
        return this.length() * f2;
    }

    public Point3DFloat divide(float f2) {
        return new Point3DFloat(this.x / f2, this.y / f2, this.z / f2);
    }

    public void divideInPlace(float f2) {
        this.x /= f2;
        this.y /= f2;
        this.z /= f2;
    }

    public float divideLength(float f2) {
        return this.length() / f2;
    }

    public static float distance(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        float f2 = point3DFloat.x - point3DFloat2.x;
        float f3 = point3DFloat.y - point3DFloat2.y;
        float f4 = point3DFloat.z - point3DFloat2.z;
        return (float)Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
    }

    public float distance(Point3DFloat point3DFloat) {
        return Point3DFloat.distance(this, point3DFloat);
    }

    public float distance(float f2, float f3, float f4) {
        float f5 = this.x - f2;
        float f6 = this.y - f3;
        float f7 = this.z - f4;
        return (float)Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
    }

    public static float distanceSquared(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        float f2 = point3DFloat.x - point3DFloat2.x;
        float f3 = point3DFloat.y - point3DFloat2.y;
        float f4 = point3DFloat.z - point3DFloat2.z;
        return f2 * f2 + f3 * f3 + f4 * f4;
    }

    public float distanceSquared(Point3DFloat point3DFloat) {
        return Point3DFloat.distanceSquared(this, point3DFloat);
    }

    public static float distance(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f2 - f5;
        float f9 = f3 - f6;
        float f10 = f4 - f7;
        return (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
    }

    public static Point3DFloat crossProduct(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        return new Point3DFloat(point3DFloat.y * point3DFloat2.z - point3DFloat.z * point3DFloat2.y, point3DFloat.z * point3DFloat2.x - point3DFloat.x * point3DFloat2.z, point3DFloat.x * point3DFloat2.y - point3DFloat.y * point3DFloat2.x);
    }

    public Point3DFloat crossProduct(Point3DFloat point3DFloat) {
        return Point3DFloat.crossProduct(this, point3DFloat);
    }

    public static Point3DFloat crossProduct(Point3DFloat point3DFloat, Point3DFloat point3DFloat2, Point3DFloat point3DFloat3) {
        Point3DFloat point3DFloat4 = new Point3DFloat(point3DFloat2.x - point3DFloat.x, point3DFloat2.y - point3DFloat.y, point3DFloat2.z - point3DFloat.z);
        Point3DFloat point3DFloat5 = new Point3DFloat(point3DFloat3.x - point3DFloat.x, point3DFloat3.y - point3DFloat.y, point3DFloat3.z - point3DFloat.z);
        return Point3DFloat.crossProduct(point3DFloat4, point3DFloat5);
    }

    public float crossProductLength(Point3DFloat point3DFloat) {
        return Point3DFloat.crossProductLength(this.x, this.y, this.z, point3DFloat.x, point3DFloat.y, point3DFloat.z);
    }

    public static float crossProductLength(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        return Point3DFloat.crossProductLength(point3DFloat.x, point3DFloat.y, point3DFloat.z, point3DFloat2.x, point3DFloat2.y, point3DFloat2.z);
    }

    public static float crossProductLength(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f3 * f7 - f4 * f6;
        float f9 = f4 * f5 - f2 * f7;
        float f10 = f2 * f6 - f3 * f5;
        return (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
    }

    public static float dotProduct(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        return point3DFloat.x * point3DFloat2.x + point3DFloat.y * point3DFloat2.y + point3DFloat.z * point3DFloat2.z;
    }

    public float dotProduct(Point3DFloat point3DFloat) {
        return Point3DFloat.dotProduct(this, point3DFloat);
    }

    public static Point3DFloat sphericalToXYZ(double d2, double d3, double d4, double d5, double d6, double d7, Point3DFloat point3DFloat) {
        double d8 = d2 * Math.sin(d3);
        float f2 = (float)(d8 * Math.cos(d4) + d5);
        float f3 = (float)(d8 * Math.sin(d4) + d6);
        float f4 = (float)(d2 * Math.cos(d3) + d7);
        if (point3DFloat == null) {
            return new Point3DFloat(f2, f3, f4);
        }
        point3DFloat.x = f2;
        point3DFloat.y = f3;
        point3DFloat.z = f4;
        return point3DFloat;
    }

    public static Point3DFloat sphericalToXYZ(Point3DDouble point3DDouble, Point3DFloat point3DFloat) {
        return Point3DFloat.sphericalToXYZ(point3DDouble.x, point3DDouble.y, point3DDouble.z, 0.0, 0.0, 0.0, point3DFloat);
    }

    public Point3DDouble toSpherical() {
        return Point3DFloat.toSpherical(this.x, this.y, this.z, 0.0, 0.0, 0.0, null);
    }

    public Point3DDouble toSpherical(Point3DDouble point3DDouble) {
        return Point3DFloat.toSpherical(this.x, this.y, this.z, 0.0, 0.0, 0.0, point3DDouble);
    }

    public static Point3DDouble toSpherical(double d2, double d3, double d4) {
        return Point3DFloat.toSpherical(d2, d3, d4, 0.0, 0.0, 0.0, null);
    }

    public static Point3DDouble toSpherical(double d2, double d3, double d4, double d5, double d6, double d7, Point3DDouble point3DDouble) {
        double d8 = d2 - d5;
        double d9 = d3 - d6;
        double d10 = d4 - d7;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = 0.0;
        if (d11 != 0.0) {
            d12 = Math.acos(d10 / d11);
        }
        double d13 = 0.0;
        double d14 = Math.sqrt(d8 * d8 + d9 * d9);
        if (d14 != 0.0) {
            d13 = Point3DFloat.signum(d9) * Math.acos(d8 / d14);
        }
        if (point3DDouble == null) {
            return new Point3DDouble(d11, d12, d13);
        }
        point3DDouble.x = d11;
        point3DDouble.y = d12;
        point3DDouble.z = d13;
        return point3DDouble;
    }

    public static Point3DFloat altAzToXYZ(double d2, double d3, double d4, double d5, double d6, double d7, Point3DFloat point3DFloat) {
        double d8 = d2 * Math.cos(d3);
        float f2 = (float)(d8 * Math.sin(d4) + d5);
        float f3 = (float)(d8 * Math.cos(d4) + d6);
        float f4 = (float)(d2 * Math.sin(d3) + d7);
        if (point3DFloat == null) {
            return new Point3DFloat(f2, f3, f4);
        }
        point3DFloat.x = f2;
        point3DFloat.y = f3;
        point3DFloat.z = f4;
        return point3DFloat;
    }

    public static Point3DFloat altAzToXYZ(Point3DDouble point3DDouble, Point3DFloat point3DFloat) {
        return Point3DFloat.altAzToXYZ(point3DDouble.x, point3DDouble.y, point3DDouble.z, 0.0, 0.0, 0.0, point3DFloat);
    }

    public Point3DDouble toAltAz() {
        return Point3DFloat.toAltAz(this.x, this.y, this.z, 0.0, 0.0, 0.0, null);
    }

    public Point3DDouble toAltAz(Point3DDouble point3DDouble) {
        return Point3DFloat.toAltAz(this.x, this.y, this.z, 0.0, 0.0, 0.0, point3DDouble);
    }

    public static Point3DDouble toAltAz(double d2, double d3, double d4) {
        return Point3DFloat.toAltAz(d2, d3, d4, 0.0, 0.0, 0.0, null);
    }

    public static Point3DDouble toAltAz(double d2, double d3, double d4, double d5, double d6, double d7, Point3DDouble point3DDouble) {
        double d8 = d2 - d5;
        double d9 = d3 - d6;
        double d10 = d4 - d7;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
        double d12 = 0.0;
        if (d11 != 0.0) {
            d12 = Math.asin(d10 / d11);
        }
        double d13 = Math.atan2(d8, d9);
        if (point3DDouble == null) {
            return new Point3DDouble(d11, d12, d13);
        }
        point3DDouble.x = d11;
        point3DDouble.y = d12;
        point3DDouble.z = d13;
        return point3DDouble;
    }

    public static Point3DFloat cylindricalToXYZ(double d2, double d3, double d4, double d5, double d6, double d7, Point3DFloat point3DFloat) {
        float f2 = (float)(d2 * Math.sin(d3) + d5);
        float f3 = (float)(d2 * Math.cos(d3) + d6);
        float f4 = (float)(d4 + d7);
        if (point3DFloat == null) {
            return new Point3DFloat(f2, f3, f4);
        }
        point3DFloat.x = f2;
        point3DFloat.y = f3;
        point3DFloat.z = f4;
        return point3DFloat;
    }

    public static Point3DFloat cylindricalToXYZ(Point3DDouble point3DDouble, Point3DFloat point3DFloat) {
        return Point3DFloat.cylindricalToXYZ(point3DDouble.x, point3DDouble.y, point3DDouble.z, 0.0, 0.0, 0.0, point3DFloat);
    }

    public Point3DDouble toCylindrical() {
        return Point3DFloat.toCylindrical(this.x, this.y, this.z, 0.0, 0.0, 0.0, null);
    }

    public Point3DDouble toCylindrical(Point3DDouble point3DDouble) {
        return Point3DFloat.toCylindrical(this.x, this.y, this.z, 0.0, 0.0, 0.0, point3DDouble);
    }

    public static Point3DDouble toCylindrical(double d2, double d3, double d4) {
        return Point3DFloat.toCylindrical(d2, d3, d4, 0.0, 0.0, 0.0, null);
    }

    public static Point3DDouble toCylindrical(double d2, double d3, double d4, double d5, double d6, double d7, Point3DDouble point3DDouble) {
        double d8 = d2 - d5;
        double d9 = d3 - d6;
        double d10 = d4 - d7;
        double d11 = Math.sqrt(d8 * d8 + d9 * d9);
        double d12 = Math.atan2(d8, d9);
        double d13 = d10;
        if (point3DDouble == null) {
            return new Point3DDouble(d11, d12, d13);
        }
        point3DDouble.x = d11;
        point3DDouble.y = d12;
        point3DDouble.z = d13;
        return point3DDouble;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public static double signum(double d2) {
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 > 0.0) {
            return 1.0;
        }
        if (d2 < 0.0) {
            return -1.0;
        }
        return d2;
    }
}

