/*
 * Decompiled with CFR 0.152.
 */
package frink.graphics;

import frink.graphics.BoundingBox3DFloat;
import frink.graphics.Point3DFloat;

public class LineSegment3DFloat {
    public Point3DFloat p1;
    public Point3DFloat p2;
    public BoundingBox3DFloat bbox = null;

    public LineSegment3DFloat(Point3DFloat point3DFloat, Point3DFloat point3DFloat2) {
        this.p1 = point3DFloat;
        this.p2 = point3DFloat2;
    }

    public LineSegment3DFloat(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.p1 = new Point3DFloat(f2, f3, f4);
        this.p2 = new Point3DFloat(f5, f6, f7);
    }

    public static LineSegment3DFloat pointAndNormal(float f2, float f3, float f4, float f5, float f6, float f7) {
        Point3DFloat point3DFloat = new Point3DFloat(f5, f6, f7).normalize();
        return new LineSegment3DFloat(f2, f3, f4, f2 + point3DFloat.x, f3 + point3DFloat.y, f4 + point3DFloat.z);
    }

    public static LineSegment3DFloat pointAndNormal(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Point3DFloat point3DFloat = new Point3DFloat(f5, f6, f7).normalize();
        return new LineSegment3DFloat(f2 + point3DFloat.x * f8, f3 + point3DFloat.y * f8, f4 + point3DFloat.z * f8, f2 + point3DFloat.x * f9, f3 + point3DFloat.y * f9, f4 + point3DFloat.z * f9);
    }

    public static LineSegment3DFloat towardPoint(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        Point3DFloat point3DFloat = new Point3DFloat(f5 - f2, f6 - f3, f7 - f4).normalize();
        return new LineSegment3DFloat(f2 + point3DFloat.x * f8, f3 + point3DFloat.y * f8, f4 + point3DFloat.z * f8, f2 + point3DFloat.x * f9, f3 + point3DFloat.y * f9, f4 + point3DFloat.z * f9);
    }

    public float distance(Point3DFloat point3DFloat) {
        return this.distance(point3DFloat.x, point3DFloat.y, point3DFloat.z);
    }

    public float distance(float f2, float f3, float f4) {
        float f5 = this.p1.distanceSquared(this.p2);
        if (f5 == 0.0f) {
            return this.p1.distance(f2, f3, f4);
        }
        float f6 = ((f2 - this.p1.x) * (this.p2.x - this.p1.x) + (f3 - this.p1.y) * (this.p2.y - this.p1.y) + (f4 - this.p1.z) * (this.p2.z - this.p1.z)) / f5;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        } else if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        return Point3DFloat.distance(f2, f3, f4, this.p1.x + f6 * (this.p2.x - this.p1.x), this.p1.y + f6 * (this.p2.y - this.p1.y), this.p1.z + f6 * (this.p2.z - this.p1.z));
    }

    public float distanceToLine(Point3DFloat point3DFloat) {
        return Point3DFloat.crossProductLength(point3DFloat.x - this.p1.x, point3DFloat.y - this.p1.y, point3DFloat.z - this.p1.z, point3DFloat.x - this.p2.x, point3DFloat.y - this.p2.y, point3DFloat.z - this.p2.z) / Point3DFloat.distance(this.p2, this.p1);
    }

    public boolean inCylinder(float f2, float f3, float f4, float f5) {
        float f6 = this.p1.distanceSquared(this.p2);
        if (f6 == 0.0f) {
            return Point3DFloat.distance(f2, f3, f4, this.p1.x, this.p1.y, this.p1.z) <= f5;
        }
        float f7 = ((f2 - this.p1.x) * (this.p2.x - this.p1.x) + (f3 - this.p1.y) * (this.p2.y - this.p1.y) + (f4 - this.p1.z) * (this.p2.z - this.p1.z)) / f6;
        if (f7 < 0.0f || f7 > 1.0f) {
            return false;
        }
        return Point3DFloat.distance(f2, f3, f4, this.p1.x + f7 * (this.p2.x - this.p1.x), this.p1.y + f7 * (this.p2.y - this.p1.y), this.p1.z + f7 * (this.p2.z - this.p1.z)) <= f5;
    }

    public boolean inTaperedCylinder(float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.p1.distanceSquared(this.p2);
        if (f7 == 0.0f) {
            return Point3DFloat.distance(f2, f3, f4, this.p1.x, this.p1.y, this.p1.z) <= Math.max(f5, f6);
        }
        float f8 = ((f2 - this.p1.x) * (this.p2.x - this.p1.x) + (f3 - this.p1.y) * (this.p2.y - this.p1.y) + (f4 - this.p1.z) * (this.p2.z - this.p1.z)) / f7;
        if (f8 < 0.0f || f8 > 1.0f) {
            return false;
        }
        float f9 = f5 + (f6 - f5) * f8;
        return Point3DFloat.distance(f2, f3, f4, this.p1.x + f8 * (this.p2.x - this.p1.x), this.p1.y + f8 * (this.p2.y - this.p1.y), this.p1.z + f8 * (this.p2.z - this.p1.z)) <= f9;
    }

    public boolean inTaperedCappedCylinder(float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8 = this.p1.distanceSquared(this.p2);
        if (f8 == 0.0f) {
            return this.p1.distance(f2, f3, f4) <= Math.max(f5, f6);
        }
        float f9 = ((f2 - this.p1.x) * (this.p2.x - this.p1.x) + (f3 - this.p1.y) * (this.p2.y - this.p1.y) + (f4 - this.p1.z) * (this.p2.z - this.p1.z)) / f8;
        if (f9 < 0.0f) {
            f9 = 0.0f;
            f7 = f5;
        } else if (f9 > 1.0f) {
            f9 = 1.0f;
            f7 = f6;
        } else {
            f7 = f5 + (f6 - f5) * f9;
        }
        return Point3DFloat.distance(f2, f3, f4, this.p1.x + f9 * (this.p2.x - this.p1.x), this.p1.y + f9 * (this.p2.y - this.p1.y), this.p1.z + f9 * (this.p2.z - this.p1.z)) <= f7;
    }

    public synchronized BoundingBox3DFloat getBoundingBox() {
        if (this.bbox == null) {
            this.bbox = new BoundingBox3DFloat(this.p1, this.p2);
        }
        return this.bbox;
    }
}

